#include <winuser.h>
#include <winbase.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

static void fatal_error(const wchar_t *cause,const long err_result,const HINSTANCE hModule);

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,wchar_t *lpCmdLine,short nShowCmd) {
HINSTANCE hCoreDLL;
short (*GetSystemMemoryDivision)(long *store_pages,long *prog_pages,long *bytes_per_page),(*SetSystemMemoryDivision)(long store_pages);
long store_pages,prog_pages,bytes_per_page,err_result;
wchar_t formstring[128],report[512]=L"System memory is divided as follows:\n";

if(*lpCmdLine==L'\0') {
hCoreDLL=LoadLibrary(L"coredll.dll");
if(hCoreDLL==NULL) {
err_result=GetLastError();
fatal_error(L"Something wicked happened initialising core library!\n",err_result,NULL);
}
GetSystemMemoryDivision=(short(*)(long*,long*,long*))GetProcAddress(hCoreDLL,L"GetSystemMemoryDivision");
if(GetSystemMemoryDivision==NULL) {
err_result=GetLastError();
fatal_error(L"Something wicked happened getting reference for GetSystemMemoryDivision function!\n",err_result,hCoreDLL);
}
if(GetSystemMemoryDivision(&store_pages,&prog_pages,&bytes_per_page)==FALSE) {
err_result=GetLastError();
fatal_error(L"Something wicked happened getting system memory division information!\n",err_result,hCoreDLL);
}
swprintf(formstring,L"%d pages (%d bytes) are being used as the object store.\n",store_pages,store_pages*bytes_per_page);
wcsncat(report,formstring,(size_t)127);
swprintf(formstring,L"%d pages (%d bytes) are being used for program memory.\n",prog_pages,prog_pages*bytes_per_page);
wcsncat(report,formstring,(size_t)127);
swprintf(formstring,L"%d pages (%d bytes) is the total available memory.\n",store_pages+prog_pages,(store_pages+prog_pages)*bytes_per_page);
wcsncat(report,formstring,(size_t)127);
swprintf(formstring,L"Each page contains %d bytes.\n",bytes_per_page);
wcsncat(report,formstring,(size_t)127);
wcsncat(report,L"To change the division, specify the number of pages for the object store on the command line.\n",(size_t)127);
if(FreeLibrary(hCoreDLL)==0) {
err_result=GetLastError();
fatal_error(L"Something wicked happened uninitialising core library!\n",err_result,hCoreDLL);
}
MessageBox(NULL,report,L"Information",MB_ICONINFORMATION);
exit(0);
}

else {
store_pages=_wtoi(lpCmdLine);
if(store_pages==0) {
MessageBox(NULL,L"Non-numeric or 0 command-line parameter.  Run with no parameters for status and usage.",L"Fatal",MB_ICONSTOP);
exit(1);
}
hCoreDLL=LoadLibrary(L"coredll.dll");
if(hCoreDLL==NULL) {
err_result=GetLastError();
fatal_error(L"Something wicked happened initialising core library!\n",err_result,NULL);
}
SetSystemMemoryDivision=(short(*)(long))GetProcAddress(hCoreDLL,L"SetSystemMemoryDivision");
if(SetSystemMemoryDivision==NULL) {
err_result=GetLastError();
fatal_error(L"Something wicked happened getting reference for SetSystemMemoryDivision function!\n",err_result,hCoreDLL);
}
switch(SetSystemMemoryDivision(store_pages)) {
case 0:
MessageBox(NULL,L"Your memory division change was successful and takes effect right now!",L"Success",MB_ICONINFORMATION);
break;
case 1:
MessageBox(NULL,L"Your memory division change was successful but requires a reset to take effect.",L"Success",MB_ICONINFORMATION);
break;
case 2:
MessageBox(NULL,L"A request requiring a reset is already pending.  Reset and try again once the previous request has taken effect.",L"Fatal",MB_ICONSTOP);
exit(1);
break;
case 3:
err_result=GetLastError();
fatal_error(L"Something wicked happened changing memory division (described failure return)!\n",err_result,hCoreDLL);
break;
default:
MessageBox(NULL,L"Something wicked happened changing memory division (unexpected/undocumented return)!",L"Fatal",MB_ICONSTOP);
exit(1);
}
if(FreeLibrary(hCoreDLL)==0) {
err_result=GetLastError();
fatal_error(L"Something wicked happened uninitialising core library!\n",err_result,hCoreDLL);
}
exit(0);
}

}

static void fatal_error(const wchar_t *cause,const long err_result,const HINSTANCE hModule) {
wchar_t report[512],formstring[128],*err_text;

wcsncpy(report,cause,wcslen(cause));
swprintf(formstring,L"The error code is %d.\n",err_result);
wcsncat(report,formstring,(size_t)127);
wcsncat(report,err_text,
FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_IGNORE_INSERTS|FORMAT_MESSAGE_FROM_HMODULE|FORMAT_MESSAGE_FROM_SYSTEM|
FORMAT_MESSAGE_MAX_WIDTH_MASK,hModule,err_result,0,&(void)err_text,0,(long**)NULL));
LocalFree(err_text);
MessageBox(NULL,report,L"Fatal",MB_ICONSTOP);
exit(1);
}
